/*******************************************************************************
 * @file    TargetAC.h
 * @brief
 ******************************************************************************/
 
/*
* Copyright  2013 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef TARGET_AC_H
#define TARGET_AC_H

#include "types.h"

void NFCTarget_init();
void NFCTarget_init_light();
void NFC_ProcessReceivedData(u08_t * buffer);
u08_t isTagSelected();

u08_t setSensRes(u08_t *data, u08_t len);
u08_t setSelRes(u08_t val);
u08_t setProtSel(u08_t *data, u08_t len);
u08_t setPadding(u08_t *data, u08_t len);
u08_t setSysCode(u08_t *data, u08_t len);
u08_t setPupi_(u08_t *data, u08_t len);
u08_t setAFI(u08_t val);
u08_t setCRCAid(u08_t *data, u08_t len);
u08_t setNumberApli(u08_t val);
u08_t setProtoInfo(u08_t *data, u08_t len);
u08_t setNfcid1(u08_t *data, u08_t len);
u08_t setNfcid2(u08_t *data, u08_t len);



#endif
